// ----------------------------------------------------------------------------
// headers
// ----------------------------------------------------------------------------
// For compilers that support precompilation, includes "wx/wx.h".

#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
#include "BOLTFrm.h"

#include "form/BOLTforms.h"

//#include "form/bfHome.h"
#include "form/bfReport.h"
//#include "form/bfSettings.h"
#include "report/brRunner.h"


#include "wx/fontutil.h"
#include "wx/image.h"
#include <wx/help.h>
#include <wx/helpbase.h> 
#include "wx/html/helpctrl.h"
#include <wx/fontenum.h>
// ----------------------------------------------------------------------------
// resources
// ----------------------------------------------------------------------------
// the application icon
#if defined(__WXGTK__) || defined(__WXMOTIF__)
	#include "BOLT.xpm"
#endif

#include "wx/notebook.h"
#include <wx/fs_zip.h>
#include <wx/tipdlg.h>
// forms

// ----------------------------------------------------------------------------
// event tables and other macros for wxWindows
// ----------------------------------------------------------------------------
enum { 
	ID_TM_CALC=BOLT_PAGES + MAX_PAGES + 100
};
// the event tables connect the wxWindows events with the functions (event
// handlers) which process them. It can be also done at run-time, but for the
// simple menu events like this the static method is much simpler.
IMPLEMENT_DYNAMIC_CLASS(BOLTFrame, wxFrame)
BEGIN_EVENT_TABLE(BOLTFrame, wxFrame)
EVT_COMMAND_RANGE(ID_HOME,ID_LOGOUT,wxEVT_COMMAND_BUTTON_CLICKED,BOLTFrame::OnButton)
EVT_MENU_RANGE(BOLT_PAGES,BOLT_PAGES+MAX_PAGES,BOLTFrame::OnPageMenu)
EVT_MENU(ID_M_CLOSEPAGE,BOLTFrame::OnClosePage)
EVT_MENU(ID_ABOUT,BOLTFrame::OnAbout)
//EVT_MENU(ID_HELP,BOLTFrame::OnHelp)
EVT_MENU(ID_TM_CALC,BOLTFrame::OnCalculator)
EVT_MENU_RANGE(wxID_UNDO,wxID_PASTE,BOLTFrame::OnMenu)
EVT_BUTTON(ID_CLOSEPAGE,BOLTFrame::OnClosePage)
#ifdef _DEMO_
EVT_BUTTON(ID_LOGOUT,BOLTFrame::OnQuit)
#else
EVT_BUTTON(ID_LOGOUT,BOLTFrame::OnLogout)
#endif
EVT_MENU(ID_M_QUITBOLT,BOLTFrame::OnQuit)
EVT_MENU(ID_M_LOGOUT,BOLTFrame::OnLogout)
//EVT_CHAR(BOLTFrame::OnChar)
//EVT_KEY_UP(BOLTFrame::OnChar)
EVT_NOTEBOOK_PAGE_CHANGED(ID_BOLT_NOTEBOOK,BOLTFrame::OnChangePage)
END_EVENT_TABLE()

// ----------------------------------------------------------------------------
// main frame
// ----------------------------------------------------------------------------
BOLTUser *user;
// frame constructor
wxHtmlHelpController *help;

#define FRAME_COLOR "GREY"
BOLTFrame::BOLTFrame(const wxString& title, const wxPoint& pos, const wxSize& size)
	   : wxFrame((wxFrame *)NULL, -1, title, pos, size)
{
	wxGetApp().frame=this;
	SetBackgroundColour(wxColour(FRAME_COLOR));
	db=NULL;
	user=NULL;
	closing=FALSE;
//init variables
	dialUp=wxDialUpManager::Create();

	LicenseContact="Bite Size, Inc. at BOLT@bitesizeinc.net";

	wxFileSystem::AddHandler(new wxZipFSHandler); 
	inOnMenu=false;
//	help=new wxHtmlHelpController(wxHF_FLAT_TOOLBAR|wxHF_CONTENTS|wxHF_INDEX|wxHF_SEARCH|wxHF_PRINT|wxHF_ICONS_BOOK_CHAPTER);
	wxString helpPath;
	#ifdef _DEMO_
	 helpPath="Demo/Help.zip";
	#else
myConfig *config=wxGetApp().config;
config->SetPath("/");
config->Read("InstallPath",&helpPath);
helpPath.Append("help.zip");
#endif
//wxMessageBox(helpPath,"Help Path");
//help->AddBook(helpPath);

 nbImgs = new wxImageList(32,32);
#define  BSCALE(x) wxImage(x).Scale(32,32).ConvertToBitmap()
nbImgs->Add(BSCALE(BITMAP_TOOLS),BSCALE(BITMASK_TOOLS));
nbImgs->Add(BSCALE(BITMAP_REPORTS),BSCALE(BITMASK_REPORTS));

	psData.EnableMargins(TRUE);
	psData.SetPaperId(wxPAPER_LETTER);
	pData.SetColour(FALSE);
	pData.SetPaperId(wxPAPER_LETTER);
	pdData.SetPrintData(pData);
	psData.SetPrintData(pData);
	formList=new wxArrayString(); //not sorted - that wouldn't work
	formList->Alloc(256);
	// set the frame icon
	SetIcon(wxICON(BOLT));
	wxMenuBar *tMB = new wxMenuBar();
	prgMenu = new wxMenu();
	tMB->Append(prgMenu,"File");
	prgMenu->Append(ID_M_CLOSEPAGE,TEXT_CLOSEPAGE,HELP_CLOSEPAGE);
#ifndef _DEMO_
	prgMenu->AppendSeparator();
	prgMenu->Append(ID_M_LOGOUT,TEXT_LOGOUT,HELP_LOGOUT);
#endif
	prgMenu->AppendSeparator();
	prgMenu->Append(ID_M_QUITBOLT,TEXT_QUITBOLT,HELP_QUITBOLT);

	hMenu = new wxMenu();
	hMenu->Append(wxID_UNDO,"Undo\tCtrl-Z","Undo last text");
	hMenu->Append(wxID_REDO,"Redo\tCtrl-Y","Redo last undo");
	hMenu->AppendSeparator();
	hMenu->Append(wxID_CUT,"Cut\tCtrl-X","Cut Text");
	hMenu->Append(wxID_COPY,"Copy\tCtrl-C","Copy Text");
	hMenu->Append(wxID_PASTE,"Paste\tCtrl-V","Paste Text");
	tMB->Append(hMenu,"Edit");

	pMenu = new wxMenu();
	tMB->Append(pMenu,"Go");

	hMenu = new wxMenu();
	hMenu->Append(ID_TM_CALC,"Calculator\tCtrl-1","Open Calculator");
	tMB->Append(hMenu,"Tools");

	hMenu = new wxMenu();
	hMenu->Append(ID_ABOUT,TEXT_ABOUT,HELP_ABOUT);
//	hMenu->Append(ID_HELP,TEXT_HELP,HELP_HELP);
	tMB->Append(hMenu,"Help");
	SetMenuBar(tMB);
	wxSizer *tSizer = new wxBoxSizer(wxVERTICAL);
//	nbWin	= new BOLT_NOTEBOOK(this);
	nbWin = new wxNotebook(this,ID_BOLT_NOTEBOOK,wxDefaultPosition,wxDefaultSize,wxNB_TOP|wxNB_MULTILINE|wxNO_3D |wxCLIP_CHILDREN|wxTAB_TRAVERSAL,"Bolt Pages");
	wxNotebookSizer *tnbSizer=new wxNotebookSizer(nbWin);
	nbWin->SetImageList(nbImgs);
	nbWin->SetBackgroundColour(wxColour(FRAME_COLOR));
	wxBoxSizer *rowSizer=new wxBoxSizer(wxHORIZONTAL);
	rowSizer->Add(bClose=new wxButton(this,ID_CLOSEPAGE,TEXT_CLOSEPAGE),0,wxALIGN_RIGHT|wxTOP|wxLEFT,2);
	rowSizer->Add(this->tHeader=new wxStaticText(this,-1,"Broker's Organized Loan Tracker",wxDefaultPosition,wxDefaultSize,wxALIGN_CENTRE),1,wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL);
#ifdef _DEMO_
	rowSizer->Add(new wxButton(this,ID_LOGOUT,"Quit"),0,wxALIGN_LEFT|wxTOP|wxLEFT,2);
#else
	rowSizer->Add(new wxButton(this,ID_LOGOUT,"Logout"),0,wxALIGN_LEFT|wxTOP|wxLEFT,2);
#endif
	tSizer->Add(rowSizer,0,wxEXPAND|wxTOP|wxLEFT|wxRIGHT,2);
	tSizer->Add(tnbSizer,1,wxEXPAND|wxALL,2);
	SetAutoLayout(TRUE);
	SetSizerAndFit(tSizer);

	/*
  wxAcceleratorEntry entries[1];
  entries[0].Set(wxACCEL_NORMAL,  WXK_ESCAPE,    ID_CLOSEPAGE);
  wxAcceleratorTable accel(1, entries);
  SetAcceleratorTable(accel);
*/
//	ShowFullScreen(TRUE,wxFULLSCREEN_NOBORDER);

#ifndef _DEMO_
if (!closing)
{
/*
	wxString tStr,tipStr;
	long tipNum;
	wxString sqlDumpExec;
	myConfig *config=wxGetApp().config;

	config->SetPath("/");

	config->Read("TipsFile",&tStr);
	if (tStr.IsEmpty()||(!wxFile::Exists(tStr))) { 
		SHOW_ERROR("Cannot Determine the Installation Directory.\n You may need to reinstall the client software.");
	} else {
	config->Read("NextTip",&tipStr);
	if (!tipStr.IsEmpty())
	{
		tipStr.ToLong(&tipNum);
        wxTipProvider *tipProvider = wxCreateFileTipProvider(tStr, tipNum);
        if (wxShowTip(this->nbWin, tipProvider))
		{
			tStr.Printf("%d",tipProvider->GetCurrentTip());
			config->Write("NextTip",tStr);
		} else
		{
			config->Write("NextTip","");
		}

	safe_delete(tipProvider);
	}
    }	
	*/
}
#endif
//	DispatchForm(ID_HOME,1);
	DispatchForm(ID_REPORTS,-1);
	Fit();
	Center();
	Show(TRUE);

}

void BOLTFrame::OnButton(wxCommandEvent &event)
{
	RECORD_ID tmpId;
	wxButton *tBut;
	if (event.GetEventObject()->IsKindOf(CLASSINFO(wxButton)))
	{
		tBut=(wxButton *)event.GetEventObject();
		tBut->GetName().ToULong(&tmpId);
	} else { tmpId=0; }
	DispatchForm(event.GetId(),tmpId);
	if (event.GetId()==ID_LOGOUT)
	{ DispatchForm(ID_REPORTS,-1); }
}

void BOLTFrame::UpdateMenus()
{
		prgMenu->Enable(ID_M_CLOSEPAGE,nbWin->GetSelection()!=0);
}
void BOLTFrame::OnChangePage(wxNotebookEvent &event)
{
	BOLTPage *tPage;
	bool showClose;
	showClose=(event.GetSelection()) >0 ;
	this->bClose->Enable(showClose);
	tPage = (BOLTPage *)this->nbWin->GetPage(event.GetSelection());
	tPage->Refresh();
	nbWin->SetPageText(event.GetSelection(),tPage->GetName());
	UpdateMenus();
}
void BOLTFrame::OnPageMenu(wxCommandEvent &event)
{
	nbWin->SetSelection(event.GetId()-BOLT_PAGES-1);
	UpdateMenus();
}

void BOLTFrame::AddQuickPicks(int formID,BOLTChooser *bc)
{
	wxArrayString fArray;
	wxString table;
wxString itemLabel;
wxString tStr;
	switch(formID)
	{
	case ID_HOME:
		//no no no
		break;
	case ID_TOOLS:
		break;
	case ID_SETTINGS:
		break;
	case ID_REPORTS:
		table="reports";
		fArray.Add("name");
		fArray.Add("created");
		bc->SetSearchFields(table,fArray);
		bc->AddQuickPicks("Reports");
		break;
	};
};

BOLTPage * BOLTFrame::DispatchForm(int formID, RECORD_ID recordID)
{

	BOLTPage *nPanel=NULL;
	BOLTLogin *loginForm;
	wxString tStr="BiteSize Reports";
	BOLTUser *nuser;
	wxCommandEvent evt(0,0);
	if (!user)
	{
		user=new BOLTUser(1,tStr);
		user->LoggedIn=false;
	} else {
			if (!user->LoggedIn) { deleteBOLTdb(&db); db=NULL; } // change Database
	}
	while (!user->LoggedIn)
		{
		while ((db==NULL)||(!db->Connected()))
		{
		if (db!=NULL)
		{
			if (db->IsError())
			{
				wxString eStr;
				eStr.Printf("Database Error : %s",db->GetError());
				SHOW_ERROR(eStr);
			} 
			else 
				{ SHOW_ERROR("Not Connected... No Error ?"); }
			deleteBOLTdb(&db);
			db=NULL;
			tHeader->SetLabel("BiteSize Reports - Copyright 2003 - Bite Size, Inc.");
			Layout();
		}
		BdbConfig *tDbConf = new BdbConfig(this);
		db = tDbConf->GetDatabase();
		tHeader->SetLabel(tDbConf->GetTitle());
		tDbConf->Destroy();
		Layout();
		Raise();
		SetFocus();
		if (closing) { return NULL; }
		}
//#ifdef _DEMO_
	tStr="BiteSize Reports";
	user=new BOLTUser(1,tStr);
//	user->font=db->GetValue("employees","font",user->id);
	user->fFont=*wxNORMAL_FONT;
	user->accessLevel=BOLT_ACCESS_OWNER;
//	tStr=db->GetValue("employees","if (classicMode=1,1,NULL)",user->id);
//	user->useClassicMode=(!tStr.IsEmpty());
	user->LoggedIn=true;
//#else
/*	loginForm = new BOLTLogin(db,this);
	nuser = loginForm->GetUser();
	if (nuser)
	{
		safe_delete(user); user=nuser;
		wxNativeFontInfo tfInfo;
		user->fFont=*wxNORMAL_FONT;
		tfInfo.FromString(user->font);
		user->fFont.SetNativeFontInfo(tfInfo);

		wxFont tFont=user->fFont;
		if (tFont.IsFixedWidth()) 
		{ this->fixedFont=user->fFont; }
		else
		{
			wxFontEnumerator fontE;
			wxArrayString* fontA;
			wxString fName;
			if (fontE.EnumerateFacenames(wxFONTENCODING_DEFAULT,TRUE))
			{ 
			  fontA=fontE.GetFacenames();
			  fName=fontA->Item(0);
			  tFont.SetFaceName(fName);
			} else 	{
			tFont.SetFaceName("Courier");
			tFont.SetFamily(wxMODERN);
			}
		}

		
	}
	loginForm->Destroy();

	if (db->IsError())
	{
		wxString eStr;
		eStr.Printf("Database Error : %s",db->GetError());
		SHOW_ERROR(eStr);
		deleteBOLTdb(&db);
		db=NULL;
	} 
*/
//#endif
	if (closing) { return NULL; }
	if (!user->LoggedIn) { deleteBOLTdb(&db); db=NULL; } // change Database
	}
	SetFont(user->fFont);
	nbWin->SetFont(user->fFont);

	BOLTChooser *BC;
	wxString idStr;
	int i;
	//Macros gone wild :-P
#define INVOKE(tbl,f,t,i,m,txt,hlp,imgI) \
	case f: \
	if (recordID==0) { \
		BC=new BOLTChooser(db,nbWin,-1); \
		AddQuickPicks(f,BC); \
		recordID=BC->GetChoice(strlen(tbl)>0,tbl,TRUE); \
		BC->Destroy(); } \
	if (recordID>0) { \
		idStr.Printf("%d-%u",f,recordID);\
		if (formList->Index(idStr.c_str())==wxNOT_FOUND) { \
		formList->Add(idStr); nPanel = t; \
		 nPanel->SetID(idStr); \
		nPanel->SetFont(user->fFont); \
		nbWin->AddPage(nPanel,nPanel->GetName(),TRUE,imgI); \
		pMenu->Append(BOLT_PAGES+nbWin->GetPageCount(),nPanel->GetName(),txt); \
		} else { RefreshForm(formID,recordID); if (formList->Index(idStr.c_str())!=wxNOT_FOUND) { nbWin->SetSelection(formList->Index(idStr.c_str())); }; }; }; \
	break;

	switch(formID) {
//	INVOKE("",ID_HOME,BOLT_FORM_HOME(nbWin,db),BITMAP_HOME,BITMASK_HOME,TEXT_HOME,HELP_HOME,0)
//	INVOKE("accounts",ID_ACCOUNTS,BOLT_FORM_ACCOUNTS(nbWin,db,recordID),BITMAP_ACCOUNTS,BITMASK_ACCOUNTS,TEXT_ACCOUNTS,HELP_ACCOUNTS,1)
//	INVOKE("multipay",ID_MULTIPAY,BOLT_FORM_MULTIPAY(nbWin,db,recordID),BITMAP_MULTIPAY,BITMASK_MULTIPAY,TEXT_MULTIPAY,HELP_MULTIPAY,1)
//	INVOKE("transactions",ID_TRANSACTIONS,BOLT_FORM_TRANSACTIONS(nbWin,db,recordID),BITMAP_TRANSACTIONS,BITMASK_TRANSACTIONS,TEXT_TRANSACTIONS,HELP_TRANSACTIONS,2)
//	INVOKE("items",ID_ITEMS,BOLT_FORM_ITEMS(nbWin,db,recordID),BITMAP_ITEMS,BITMASK_ITEMS,TEXT_ITEMS,HELP_ITEMS,3)
//	INVOKE("registers",ID_REGISTER,BOLT_FORM_REGISTER(nbWin,db,recordID),BITMAP_REGISTER,BITMASK_REGISTER,TEXT_REGISTER,HELP_REGISTER,4)
//	INVOKE("settings",ID_TOOLS,BOLT_FORM_SETTINGS(nbWin,db,recordID),BITMAP_TOOLS,BITMASK_TOOLS,TEXT_TOOLS,HELP_SETTINGS,5)
	INVOKE("reports",ID_REPORTS,BOLT_FORM_REPORTS(nbWin,db,recordID),BITMAP_REPORTS,BITMASK_REPORTS,TEXT_REPORTS,HELP_REPORTS,6)
	case ID_LOGOUT:
				closing=true;

		nPanel=NULL;
		BOLTPage *cWin;
		for (i=nbWin->GetPageCount();i>0;i--)
		{
			pMenu->Delete(BOLT_PAGES+i);
			cWin=(BOLTPage *)nbWin->GetPage(i-1);
			nbWin->RemovePage(i-1);
			formList->Remove(cWin->GetID());
			cWin->Show(FALSE);
			cWin->Close(TRUE);
			cWin->Destroy();
		}
		closing=false;
		user->LoggedIn=false;
	return NULL;
		break;
	case ID_CLOSEPAGE:
		nPanel=NULL;
		UpdateMenus();

		this->OnClosePage(evt);
		return NULL;
		break;
	default:
		nPanel=NULL;
		wxMessageBox("Invalid Dispatch ID");
		break;
	}	
#ifdef __WXDEBUG__
//	wxDebugContext::Check();
//	wxDebugContext::Dump();
//	wxDebugContext::PrintStatistics(TRUE);
#endif 	
	return nPanel;
}
// event handlers
void BOLTFrame::RefreshForm(int formID, RECORD_ID recordID)
{
}

void BOLTFrame::OnClosePage(wxCommandEvent &event)
{
	BOLTPage *cWin;
	int iPage;

	iPage=nbWin->GetSelection();
	if (iPage>0)
	{
		for ( int i=iPage+1;i <nbWin->GetPageCount();i++)
		{
			pMenu->SetLabel(BOLT_PAGES+i,pMenu->GetLabel(BOLT_PAGES+i+1));
		}
		cWin=(BOLTPage *)nbWin->GetPage(iPage);
		formList->Remove(cWin->GetID());
		pMenu->Destroy(BOLT_PAGES+nbWin->GetPageCount());
		cWin->Close(TRUE);
		nbWin->RemovePage(iPage);
		cWin->Destroy();
		nbWin->SetSelection(nbWin->GetPageCount()-1);
//		formList->Shrink();
//		cWin->Close(TRUE);
//		cWin->Show(FALSE);
#ifdef __WXDEBUG__
//		wxDebugContext::Dump();
//		wxDebugContext::PrintStatistics();
#endif
	}

}

void BOLTFrame::OnQuit(wxCommandEvent& event)
{
	// TRUE is to force the frame to close
#ifdef _DEMO_
	this->OnAbout(event);
#endif
	Close(TRUE);
}

bool BOLTFrame::Close(bool force)
{
	this->closing=true;
//	return false;
	return wxFrame::Close(force);
}


void BOLTFrame::OnLogout(wxCommandEvent& event)
{
DispatchForm(ID_LOGOUT,1);
DispatchForm(ID_REPORTS,-1);
}

void BOLTFrame::OnAbout(wxCommandEvent& event)
{
	wxString msg;
	msg.Printf( _T("Bring It To Everybody\nSQL Reports\nWritten by Christopher Todd\nDistributed by Bite Size, Inc.\nCopyright 2003\n\nWebsite : http://www.bitesizeinc.net/"));
	wxMessageBox(msg, "About BITE", wxOK | wxICON_INFORMATION, this);
}

BOLTFrame::~BOLTFrame()
{
	formList->Clear();
	closing=true;
	safe_delete(formList);
	safe_delete(dialUp);
	if (db!=NULL)
		{ deleteBOLTdb(&db); }
	safe_delete(user);
	safe_delete(this->nbImgs);
//	safe_delete(help);
}

void BOLTFrame::ReopenForm(int formID, RECORD_ID recordID)
{
//	BOLTPage *cWin;
/*	if (nbWin->GetSelection()>0)
	{
		for ( int i=nbWin->GetSelection()+1;i <nbWin->GetPageCount();i++)
		{
			pMenu->SetLabel(BOLT_PAGES+i,pMenu->GetLabel(BOLT_PAGES+i+1));
		}
		pMenu->Delete(BOLT_PAGES+nbWin->GetPageCount());
		cWin=(BOLTPage *)nbWin->GetPage(nbWin->GetSelection());
		formList->Remove(cWin->GetID());
		nbWin->RemovePage(nbWin->GetSelection());
		nbWin->SetSelection(nbWin->GetPageCount()-1);
		cWin->Close();
	}
*/


	DispatchForm(formID,recordID);
	wxCommandEvent evt(0,0);
	OnClosePage(evt);
	DispatchForm(formID,recordID);

//	RefreshForm(formID,recordID);
}

void BOLTFrame::OnChar(wxKeyEvent &event)
{
	if (event.GetKeyCode()==WXK_ESCAPE)
	{
		DispatchForm(ID_CLOSEPAGE,1);
	} else {
	event.Skip();
	}
}

double BOLTFrame::QuickPay(RECORD_ID transactionId)
{
//launch the transaction's QuickPay virtual function
	wxString idStr;

//	if (transactionId>0) { 
//		idStr.Printf("%u-%u",ID_TRANSACTIONS,transactionId); 
//		if (formList->Index(idStr.c_str())!=wxNOT_FOUND) 
//		{
//				return ((bfTransaction *)nbWin->GetPage(
//					formList->Index((char *)idStr.c_str())))->QuickPay();
//		}
//	}
	return 0;
}

void BOLTFrame::OnHelp(wxCommandEvent &event)
{
//	help->DisplayContents();
}

void BOLTFrame::OnMenu(wxCommandEvent &event)
{
	wxWindow *cWin;
	cWin=wxWindow::FindFocus();
	if (cWin&&(cWin!=this)&&(!inOnMenu))
	{
		inOnMenu=true;
		cWin->ProcessEvent(event);
	}
	inOnMenu=false;
}

wxString BOLTFrame::AquireLicense()
{
return "";
}

void BOLTFrame::FreeLicense()
{
}

void BOLTFrame::LicenseViolation()
{
}

bool BOLTFrame::IsValidLicense(wxString code)
{
return true;
}

BOLTFrame::BOLTFrame()
{
	BOLTFrame("BOLT",wxDefaultPosition,wxDefaultSize);
}

void BOLTFrame::OnCalculator(wxCommandEvent &event)
{
	wxString tPath;
myConfig *config=wxGetApp().config;
config->SetPath("/");
config->Read("CalculatorPath",&tPath);

while ((!wxFileExists(tPath))||(wxExecute(tPath,wxEXEC_ASYNC)==-1))
{
	if(wxMessageBox("Please locate the calculator program","Not Found",wxOK|wxCANCEL|wxCENTRE,this)==wxCANCEL)
	{ return; }
	tPath=wxFileSelector("Where is the Calculator Program ?",
					"/windows/system32",
					"calc", "exe","Executable|*.exe",wxFILE_MUST_EXIST,this);
}
config->Write("CalculatorPath",tPath);
}
